#define amount (0.25f)
float rand(float2 n)
{
	float m = sin(dot(n, (float2)(12.9898f, 78.233f))) * 43758.5453f;
	float i;
	return fract(m, &i);
}

__kernel void MAIN(__read_only image2d_t image,   		// image image
				   __write_only image2d_t retImage,   	// image result
				   __global FilterParam* param,
				   __private int percent,				// scrope[0-100]
				   __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_global_size(0);
	int height = get_global_size(1);
	int globalTime = param->cur_time;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
//	if(w < width && h < height)
	{
		float4 color = read_imagef(image, sampler, (int2)(w, h));
		float a = color.w;
		
		float sizeRattio = (float)(percent) / 100;
		float2 uv = (float2)((float)(w) / width, (float)(h) / height);
		float val = amount * sizeRattio * (1.9f * rand(uv + globalTime*10.0f) - 1.0f);
		float factor = (float)(alpha)/100.0f;
		
		color += val * factor;
		
		float4 retColor = (float4)(color.xyz, a);
		
		write_imagef(retImage, (int2)(w, h), retColor);
	}
}